%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 1.8(c)
% File: JB_GJBtest.m
%
% Performs a Jarque-Bera (JB) (independent time series data) 
% and a GJB (weakly dependent time series data) test for normality. 
%
% INPUT:  data
% OUTPUT: JB, pvalueJB, GJB, pvalueGJB
%
% Reference:
% Jarque, C.M. and Bera, A.K. (1987). 
%   A test for normality of observations and regression residuals.
%   International Statistical Review, 55(2), 163-172.
%   DOI: 10.2307/1403192. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nr  = length(data);
val = skewness(data)^2;
val = val + (1/4)*(kurtosis(data)-3)^2;
JB  = (nr/6)* val;
pvalueJB = 1-chi2cdf(JB,2);
Z = data;
Z = Z(:)'-mean(Z);
y    = filter(Z(nr:-1:1),1,Z);
acvf = y(nr:-1:1)/nr;
sum3 = 0;
sum4 = 0;
for i = 2:nr-1 
    sum3 = sum3 + 2*acvf(i)^3;
    sum4 = sum4 + 2*acvf(i)^4;   
end
F3  = acvf(1)^3+sum3;
F4  = acvf(1)^4+sum4;
m2  = moment(data,2);
m3  = moment(data,3)^2/F3;
GJB = m3 + (1/4)*(moment(data,4)-3*m2*m2)^2/F4; 
GJB = (nr/6)*GJB;
pvalueGJB = 1-chi2cdf(GJB,2);
